/* Program for HY book Scanner  20141219   Hiroshi Yanagisawa */
/* Add Fix for multi page Feed error ( down platen box for short time during paper lift.
  extend blow duration to prevent page return failure
 optimize camera kick timing to absorve AF delay
 Feed test routine and Auto scan routine updatred
 */
 
 /* 
  Add pressure sense rutine  20141211
  serial monitor routine active
*/
//start of pressure sense 
#include <Wire.h>
#define BMP085_ADDRESS 0x77  // I2C address of BMP085
const unsigned char OSS = 0;  // Oversampling Setting
// Calibration values
int ac1;
int ac2; 
int ac3; 
unsigned int ac4;
unsigned int ac5;
unsigned int ac6;
int b1; 
int b2;
int mb;
int mc;
int md;
// b5 is calculated in bmp085GetTemperature(...), this variable is also used in bmp085GetPressure(...)
// so ...Temperature(...) must be called before ...Pressure(...).
long b5; 
short temperature;
long pressure;
long lowpressure; //20141211
long normpressure; //20141211
int pickuperr = 0 ; //20141211
// end of pressure sense

// These constants won't change:
const int potPin = A0;    // pin that the paper size volume is attached to
const int g2topPin = A2;    // pin that g2top buttom is attached to
const int g2botPin = A3;    // pin that g2bot buttom is attached to
const int testPin = A1;    // pin that test page turn buttom is attached to
const int ssPin = 5;    // pin that single step scan SW is attached to
const int scanPin = 6;    // pin that auto scan SW  is attached to
const int piPin = 7;   // pin that Photo interrupter is attached to
const int motorPin = 2;       // pin that the motor SSR is attached to
const int vuccPin = 3;       // pin that the vuccume SSR is attached to
const int blowPin = 4;       // pin that the blow SSR is attached to
const int ir1Pin = 9;   // pin that IR LED #1 is attached to
//const int ir2Pin = 10;   // pin that IR LED #2 is attached to not used 
const int airsepPin = 8 ;  //20141205 pin that air separator relay attached 

// define and initialize variables
unsigned long TatPI;
unsigned long now;
int vucoff;
int blowon;
int blowoff;
int scanstat = 0;
int airsepoff ;
// MX-1 shutter ON
unsigned int data[] = {1302,301,100,102,100,102,100,101,100,102,100,102,100,102,100
};
int last = 0;
unsigned long us = micros();
// 20141201 added variables for motoroff fix
int motorofftiming ;
int motorreon ;


 
// parameter table

// time to top position
const int top = 4300 ;
// time to bottom position
const int bot = 330 ;
// time to take picture
const int camera = 150 ;
// time of start vaccume
const int vucon = 400 ;
// Vuc duration   ( caluculated from pot )
int vucdur  ;
// over lap between blow and vuccum
const int overlap = 100 ;
// blow duration
const int blowdur = 1500 ;
// 20141205 air separator on duration
const int airsepdur =1500 ;

//20141201  motor off location   x/8
const int motoroffratio =6 ;
//20141201  motor off duration
const int motoroffdur =450 ;
//20141201 time for recover motor off duration
const int losttime = 700 ;


// main routines
//g2top
//g2bot
//singlestep
//test page turn
//auto



void setup() {
  // initialize the SSR pin as an output:
  pinMode(motorPin, OUTPUT);
  pinMode(vuccPin, OUTPUT);
  pinMode(blowPin, OUTPUT);
  // initialize the SSR pin as an output:
  pinMode(ir1Pin, OUTPUT);
  //pinMode(ir2Pin, OUTPUT);
  pinMode(airsepPin, OUTPUT) ; //20141205 air separator relay control
  
  // initialize button , SW and photo interrupt pin as input:
  pinMode(g2topPin, INPUT);
  pinMode(g2botPin, INPUT);
  pinMode(testPin, INPUT);
  pinMode(ssPin, INPUT);
  pinMode(scanPin, INPUT);
  pinMode(piPin, INPUT);
   
  // Add pullup resistor to input pins
  digitalWrite(g2topPin,HIGH);
  digitalWrite(g2botPin,HIGH);
  digitalWrite(testPin,HIGH);
  digitalWrite(ssPin,HIGH);
  digitalWrite(scanPin,HIGH);
  digitalWrite(piPin,HIGH);
  // start of pressure sense
   Serial.begin(9600);
  Wire.begin();
  bmp085Calibration();
  temperature = bmp085GetTemperature(bmp085ReadUT());//temp measure only once
  // end of pressure sense
}

void loop() {
  // check go to top button if yes do g2top:
  if ( digitalRead(g2topPin) == LOW ){ g2top(); } 
  if ( digitalRead(g2botPin) == LOW ){g2bot();}
  if ( digitalRead(testPin) == LOW ){test() ; }
  if ( digitalRead(ssPin) == LOW ){ss() ; }
  if (( digitalRead(scanPin) == LOW )&&(pickuperr<3)){scan() ; }
  delay(10);
  } 
  





// sub routines
// 
//Go to Top position 
 void g2top(){
   int x=0;  //kick motor and waite for Photo int ,
    pickuperr =0 ; // reset paper pickup error
   digitalWrite(motorPin,HIGH);
   do {
     delay(10);
     x=digitalRead(piPin);
   }while(x==0);
   TatPI = millis();   
//Delay given ms from PI  
 now = millis() ;
 while((now - TatPI )< top){
   delay(10);
   now = millis();
 }
digitalWrite(motorPin,LOW) ;
 return ;
}

//Go to Bottom position 
 void g2bot(){
   int x=0;  //kick motor and waite for Photo int ,
   pickuperr =0 ; // reset paper pickup error
   digitalWrite(motorPin,HIGH);
   do {
     delay(10);
     x=digitalRead(piPin);
   }while(x==0);
   TatPI = millis();   
//Delay given ms from PI  
 now = millis() ;
 while((now - TatPI )< bot){
   delay(10);
   now = millis();
 }
digitalWrite(motorPin,LOW) ;
 return ;
}

//Single Step (take photo w/o page turn , stop at top position)
 void ss(){
   int x=0;  //kick motor and waite for Photo int ,
    pickuperr =0 ; // reset paper pickup error
   digitalWrite(motorPin,HIGH);
   do {
     delay(10);
     x=digitalRead(piPin);
   }while(x==0);
   TatPI = millis();   
//wait untill shutter timing  then take photo 
 now = millis() ;
 while((now - TatPI )< camera){
   delay(10);
   now = millis();
 }
writeIR ();
//move to top then stop  
 now = millis() ;
 while((now - TatPI )< top){
   delay(10);
   now = millis();
 }
 digitalWrite(motorPin, LOW);
 return ;
}


//Page turn test 1回転でページ送りのテスト。Volでページの大きさに合わせる
 void test(){
   int x=0;  //kick motor and waite for Photo int 
  pickuperr =0 ; // reset paper pickup error,
   digitalWrite(motorPin,HIGH);
   do {
     delay(10);
     x=digitalRead(piPin);
   }while(x==0);
   TatPI = millis();   
//wait untill Vuc on timing   
 now = millis() ;
 while((now - TatPI )< vucon){
   delay(10);
   now = millis();
 }
   digitalWrite(vuccPin, HIGH);
   digitalWrite(airsepPin, HIGH); // 20141205 air separator fan is on
  
  //20141205 wait for Air Separator OFF timing 
   now = millis() ;
 while((now - TatPI )< (vucon + airsepdur)){
   delay(10);
   now = millis();
 }
 digitalWrite(airsepPin, LOW) ; // 20141205 air separator fan is off
 
 // 20141201 calc motor off timing
motorofftiming =(( ReadPot() / 8 ) * motoroffratio ) + vucon ;
// wait for motor off timing for multi page feed  error prevention
 
 now = millis() ;
 while((now - TatPI )< motorofftiming){
   delay(10);
   now = millis();
 }
// temp motor off
   digitalWrite(motorPin, LOW);
//wait for motor re kick
motorreon = motorofftiming + motoroffdur ;
 now = millis() ;
 while((now - TatPI )< motorreon){
   delay(10);
   now = millis();
 }
 // re kick motor
   digitalWrite(motorPin, HIGH);
    
// 20141201  adjust  vucoff because of motor off 
vucoff = vucon + ReadPot() + losttime;  // added lost time
blowon = vucoff-overlap;


//wait for Blow on position  
 now = millis() ;
 while((now - TatPI )< blowon){
   delay(10);
   now = millis();
 }
 digitalWrite(blowPin, HIGH);
 //wait for vuccume off position  
 now = millis() ;
 while((now - TatPI )< vucoff){
   delay(10);
   now = millis();
 }
 digitalWrite(vuccPin, LOW);
 // wait for blow off
    now = millis() ;
 while((now - TatPI )< (blowon+blowdur)){
   delay(10);
   now = millis();
 }
 digitalWrite(blowPin, LOW);
 
// 1more rotation and stop at top
   int xx= 0 ;  //reset Pi flag
   do {
     delay(10);
     xx=digitalRead(piPin);
   }while(xx==0);
   TatPI = millis();   
//Delay given ms from PI  
 now = millis() ;
 while((now - TatPI )< top){
   delay(10);
   now = millis();
 }
digitalWrite(motorPin,LOW) ;

 return ;
}

// Auto  撮影しPageTurn その後Auto SWをチェック、オンならそのまま次のサイクル
// AutoSWがオフならTopで止まる。
 void scan(){
  int x=0;  //kick motor and waite for Photo int ,
  pressure = bmp085GetPressure(bmp085ReadUP());// 20141211
  normpressure = pressure;
  Serial.print("1stnormPressure: ");
  Serial.print(pressure, DEC);
  Serial.println(" Pa");
  Serial.println();
  // 
  digitalWrite(motorPin,HIGH);
  do{
  do {
   delay(10);
  x=digitalRead(piPin);
 }while(x==0);
 TatPI = millis();  
   
 //wait untill shutter timing  then take photo 
now = millis() ;
 while((now - TatPI )< camera){
   delay(10);
  now = millis();
 }
// if paperpick up success  kick IR 20141211
if (pickuperr ==0) {writeIR (); }

//wait untill Vuc on timing   
 now = millis() ;
 while((now - TatPI )< vucon){
   delay(10);
   now = millis();
 }
   digitalWrite(vuccPin, HIGH);
     digitalWrite(airsepPin, HIGH); // 20141205 air separator fan is on
  
  //20141205 wait for Air Separator OFF timing 
   now = millis() ;
 while((now - TatPI )< (vucon + airsepdur)){
   delay(10);
   now = millis();
 }
 digitalWrite(airsepPin, LOW) ; // 20141205 air separator fan is off
 
 
   
 // 20141201 calc motor off timing
motorofftiming =(( ReadPot() / 8 ) * motoroffratio ) + vucon ;
// wait for motor off timing for multi page feed  error prevention
 
 now = millis() ;
 while((now - TatPI )< motorofftiming){
   delay(10);
   now = millis();
 }
// temp motor off
   digitalWrite(motorPin, LOW);
// check  low pressure  
pressure = bmp085GetPressure(bmp085ReadUP());
  Serial.print("LowPressure: ");
  Serial.print(pressure, DEC);
  Serial.println(" Pa");
  Serial.println();
  lowpressure = pressure ;
  if (normpressure < lowpressure+500)
  { pickuperr = pickuperr + 1; // paper pickup failed
  }
  else {pickuperr = 0;}
//wait for motor re kick
motorreon = motorofftiming + motoroffdur ;
 now = millis() ;
 while((now - TatPI )< motorreon){
   delay(10);
   now = millis();
 }
 // re kick motor
   digitalWrite(motorPin, HIGH);
    
// 20141201  adjust  vucoff because of motor off 
vucoff = vucon + ReadPot() + losttime;  // added lost time
blowon = vucoff-overlap;


//wait for Blow on position  
 now = millis() ;
 while((now - TatPI )< blowon){
   delay(10);
   now = millis();
 }
 digitalWrite(blowPin, HIGH);
 //wait for vuccume off position  
 now = millis() ;
 while((now - TatPI )< vucoff){
   delay(10);
   now = millis();
 }
 digitalWrite(vuccPin, LOW);

  
 //Check autoSW  
 scanstat=digitalRead(scanPin); // Auto scan sw still on
 if (scanstat == LOW){  
  now = millis() ;
 while((now - TatPI )< (blowon+blowdur)){
  delay(10);
   now = millis();
 }
 digitalWrite(blowPin, LOW);
 delay(1000); // wait 1sec then measure pressure 20141211
 pressure = bmp085GetPressure(bmp085ReadUP());
 normpressure = pressure ;
  Serial.print("NormPressure: ");
  Serial.print(pressure, DEC);
  Serial.println(" Pa");
  Serial.println();
 }
 else {delay(1);
  }
  } while ((scanstat == LOW)&&(pickuperr<3));  // most outside do while
 //  
   
 //in case of Auto SW is off or Pick up retry exceeded  3 times

   now = millis() ;
 while((now - TatPI )< (blowon+blowdur)){
   delay(10);
  now = millis();
}
 digitalWrite(blowPin, LOW);
 delay(1000);
 pressure = bmp085GetPressure(bmp085ReadUP());
 normpressure = pressure;
  Serial.print("NormPressure: ");
  Serial.print(pressure, DEC);
  Serial.println(" Pa");
  Serial.println();
 
// 1more rotation and stop at top
   int xx= 0 ;  //reset Pi flag
   do {
     delay(10);
     xx=digitalRead(piPin);
   }while(xx==0);
   TatPI = millis();   
//Delay given ms from PI  
 now = millis() ;
 while((now - TatPI )< top){
   delay(10);
   now = millis();
 }
digitalWrite(motorPin,LOW) ;

 
 return ;
}

//read pot 値は0-255の範囲で時間2000ms-4550msの値を返す
int ReadPot(){
  int i;
  int sval;

  for (i = 0; i < 5; i++){
    sval = sval + analogRead(potPin);  // アナログ入力ピン0のセンサから
  }
  sval = sval / 5;    // 平均
  sval = sval / 4;    // 8ビット化(0 - 255)
  vucdur=2000 + (sval * 10);  //20141201 update
  return vucdur ;
}


//write IR
// dataからリモコン信号を送信
void writeIR() {
  int dataSize = sizeof(data) / sizeof(data[0]);
  for (int cnt = 0; cnt < dataSize; cnt++) {
    unsigned long len = data[cnt]*10;  // dataは10us単位でON/OFF時間を記録している
    unsigned long us = micros();
    do {
      digitalWrite(ir1Pin, 1 - (cnt&1)); // cntが偶数なら赤外線ON、奇数ならOFFのまま
      delayMicroseconds(8);  // キャリア周波数38kHzでON/OFFするよう時間調整
      digitalWrite(ir1Pin, 0);
      delayMicroseconds(7);
    } while (long(us + len - micros()) > 0); // 送信時間に達するまでループ
  }
  return;
}
 
//start of pressure sense subroutines

void bmp085Calibration()
{
  ac1 = bmp085ReadInt(0xAA);
  ac2 = bmp085ReadInt(0xAC);
  ac3 = bmp085ReadInt(0xAE);
  ac4 = bmp085ReadInt(0xB0);
  ac5 = bmp085ReadInt(0xB2);
  ac6 = bmp085ReadInt(0xB4);
  b1 = bmp085ReadInt(0xB6);
  b2 = bmp085ReadInt(0xB8);
  mb = bmp085ReadInt(0xBA);
  mc = bmp085ReadInt(0xBC);
  md = bmp085ReadInt(0xBE);
}

// Calculate temperature given ut.
// Value returned will be in units of 0.1 deg C
short bmp085GetTemperature(unsigned int ut)
{
  long x1, x2;
  
  x1 = (((long)ut - (long)ac6)*(long)ac5) >> 15;
  x2 = ((long)mc << 11)/(x1 + md);
  b5 = x1 + x2;

  return ((b5 + 8)>>4);  
}

// Calculate pressure given up
// calibration values must be known
// b5 is also required so bmp085GetTemperature(...) must be called first.
// Value returned will be pressure in units of Pa.
long bmp085GetPressure(unsigned long up)
{
  long x1, x2, x3, b3, b6, p;
  unsigned long b4, b7;
  
  b6 = b5 - 4000;
  // Calculate B3
  x1 = (b2 * (b6 * b6)>>12)>>11;
  x2 = (ac2 * b6)>>11;
  x3 = x1 + x2;
  b3 = (((((long)ac1)*4 + x3)<<OSS) + 2)>>2;
  
  // Calculate B4
  x1 = (ac3 * b6)>>13;
  x2 = (b1 * ((b6 * b6)>>12))>>16;
  x3 = ((x1 + x2) + 2)>>2;
  b4 = (ac4 * (unsigned long)(x3 + 32768))>>15;
  
  b7 = ((unsigned long)(up - b3) * (50000>>OSS));
  if (b7 < 0x80000000)
    p = (b7<<1)/b4;
  else
    p = (b7/b4)<<1;
    
  x1 = (p>>8) * (p>>8);
  x1 = (x1 * 3038)>>16;
  x2 = (-7357 * p)>>16;
  p += (x1 + x2 + 3791)>>4;
  
  return p;
}

// Read 1 byte from the BMP085 at 'address'
char bmp085Read(unsigned char address)
{
  unsigned char data;
  
  Wire.beginTransmission(BMP085_ADDRESS);
  Wire.write(address);
  Wire.endTransmission();
  
  Wire.requestFrom(BMP085_ADDRESS, 1);
  while(!Wire.available())
    ;
    
  return Wire.read();
}

// Read 2 bytes from the BMP085
// First byte will be from 'address'
// Second byte will be from 'address'+1
int bmp085ReadInt(unsigned char address)
{
  unsigned char msb, lsb;
  
  Wire.beginTransmission(BMP085_ADDRESS);
  Wire.write(address);
  Wire.endTransmission();
  
  Wire.requestFrom(BMP085_ADDRESS, 2);
  while(Wire.available()<2)
    ;
  msb = Wire.read();
  lsb = Wire.read();
  
  return (int) msb<<8 | lsb;
}

// Read the uncompensated temperature value
unsigned int bmp085ReadUT()
{
  unsigned int ut;
  
  // Write 0x2E into Register 0xF4
  // This requests a temperature reading
  Wire.beginTransmission(BMP085_ADDRESS);
  Wire.write(0xF4);
  Wire.write(0x2E);
  Wire.endTransmission();
  
  // Wait at least 4.5ms
  delay(5);
  
  // Read two bytes from registers 0xF6 and 0xF7
  ut = bmp085ReadInt(0xF6);
  return ut;
}

// Read the uncompensated pressure value
unsigned long bmp085ReadUP()
{
  unsigned char msb, lsb, xlsb;
  unsigned long up = 0;
  
  // Write 0x34+(OSS<<6) into register 0xF4
  // Request a pressure reading w/ oversampling setting
  Wire.beginTransmission(BMP085_ADDRESS);
  Wire.write(0xF4);
  Wire.write(0x34 + (OSS<<6));
  Wire.endTransmission();
  
  // Wait for conversion, delay time dependent on OSS
  delay(2 + (3<<OSS));
  
  // Read register 0xF6 (MSB), 0xF7 (LSB), and 0xF8 (XLSB)
  Wire.beginTransmission(BMP085_ADDRESS);
  Wire.write(0xF6);
  Wire.endTransmission();
  Wire.requestFrom(BMP085_ADDRESS, 3);
  
  // Wait for data to become available
  while(Wire.available() < 3)
    ;
  msb = Wire.read();
  lsb = Wire.read();
  xlsb = Wire.read();
  
  up = (((unsigned long) msb << 16) | ((unsigned long) lsb << 8) | (unsigned long) xlsb) >> (8-OSS);
  
  return up;
}
